{ Max Pascal interface to the CDEV Manager by Darryl Lovato
  Copyright (c) 1989-1990 by Apple Computer, Inc. }

unit CDEVIntF;

interface

const
	MachineCDEV =		1;	{ machine test, return 0 if NOT ok to run on this machine }
	BootCDEV =			2;	{ boot time init call or Install call - no parms }
	ShutDownCDEV =		3;	{ shut down or de-install the CDEV - no parms }
	InitCDEV =			4;	{ called when being shown - data1 = windowPtr }
	CloseCDEV =			5;	{ called when being removed - data1 = windowPtr }
	EventsCDEV =		6;	{ call3ed when an event - data1 = ptr to event record }
	CreateCDEV =		7;	{ called so that a CDEV can create its controls inline - data1 = window }
	AboutCDEV =			8;	{ called so that a CDEV can create its about text inline - no parms }
	RectCDEV =			9;	{ called so that a CDEV can dynamically compute its rectangle data1 = rectprr }
	HitCDEV =			10;	{ called when ctl is "hit" - data1 = Hdl to ctl hit, data2 = Ctl Id }
	RunCDEV =			11;	{ called when daRun is called }
	reserved1 =			12;	{ reserved for Apple Computer's future use }
	reserved2 =			13;	{ reserved for Apple Computer's future use }
	reserved3 =			14;	{ reserved for Apple Computer's future use }
	NeverUsed1 =		15;
	NeverUsed2 =		16;

	wantMachine =		1;	{ these flags are set in the CDEV flags resource to tell the Control }
	wantBoot =			2;	{ panel which of the above messages the CDEV actually needs }
	wantShutDown =		4;
	wantInit =			8;
	wantClose =			16;
	wantEvents =		32;
	wantCreate =		64;
	wantAbout =			128;
	wantRect =			256;
	wantHit =			512;
	wantRun =			1024;
	wantReserved1 =		2048;
	wantReserved2 =		4096;
	wantReserved3 =		8192;
	updateSSfromBRAM =	16384;	{ this is for use by Apple Computer, Inc ONLY! <- I mean it! }
	CanBeUnActive =		32768;	{ set this bit if the cdev can be made inactive by the user }

implementation

end.
